/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/
/** ****************************************************************************
 * @file     auto_uart_baudrate.h
 * @author
 * @date
 * @version  v1.0.0
 * @brief    Header for auto_uart_baudrate.c module
 ******************************************************************************/
#ifndef __AUTO_UART_BAUDRATE_H
#define __AUTO_UART_BAUDRATE_H

#ifdef __cplusplus
 extern "C" {
#endif

#include "main.h"

#define DEFAULT_BAUD_RATE  9600

//Exported types ---------------------------------------------------------------
#define FLASH_NVR_TIMEOUT_ADDR         ((uint16_t*)0x1FFFF240)
#define FLASH_NVR_UNPROGRAM_HW         ((uint16_t)0xFFFF)

typedef enum
{
  UART_STA1    = 0xAA,
  UART_STA2    = 0x55
} UART_CMD_ENUM;

//Exported constants -----------------------------------------------------------

//Exported macro ---------------------------------------------------------------
//Exported functions -----------------------------------------------------------
void UART_Config(void);
void Uart_Receive(uint8_t data);
void Uart_Send(uint16_t Num,uint8_t *pData);
void Send_Data(uint16_t data);
#ifdef __cplusplus
}
#endif

#endif //__AUTO_UART_BAUDRATE_H
